

#ifndef _KINECT_H_
#define _KINECT_H_
//#include "OpenGL.h"
#include "KinectFunction.h"
#include "BodyInfo.h"
#include <GL/glut.h>	// glut.h includes the other two automatically in Win32
#define MAX_DEPTH 10000


class Kinect
{
private:
	//kinect id
	int id;
	// windows stuff
	HDC		m_hDC;			// The device context for OpenGL
	HGLRC	m_hRC;			// Render Context for OpenGL
	// viewing
	int		m_view_width;
	int		m_view_height;
	float	m_view_aspect;
	float	m_view_fov;
	float	m_view_near_clip;
	float	m_view_far_clip;
	//kinect
	XnUInt32 nColors;
	float g_pDepthHist[MAX_DEPTH];
	GLfloat texcoords[8];
	BodyInfo body; 
public:
	Kinect(int );
	~Kinect(void);
	int getID();
	int initKinect();
	void updateBodyInfo();
	//void OpenGLInit(HDC the_device_context);
	//void OpenGLUnInit(void);
	BodyInfo getBodyInfo() const;
private://private functions
	/*
	void OpenGLSetup(void);
	void Set_Viewport3D(void);
	void Set_Viewport2D(void);
	void Finish_Render(void);
	void OpenGLDisplay(void);
	void KinectDrawDepthMap(const xn::DepthMetaData& dmd, const xn::SceneMetaData& smd);
	void KinectDrawTexture(float topLeftX, float topLeftY, float bottomRightX, float bottomRightY);
	void KinectDrawRectangle(float topLeftX, float topLeftY, float bottomRightX, float bottomRightY);
	void KinectDrawLimb(XnUserID player, XnSkeletonJoint eJoint1, XnSkeletonJoint eJoint2);
	GLuint KinectInitTexture(void** buf, int& width, int& height);
	unsigned int getClosestPowerOfTwo(unsigned int n);
	void glPrintString(void *font, char *str);
	void Set_Viewport_Size(int width, int height);
	*/
};

#endif